<?php
/**
 * Grocery Online Store: Block Patterns
 *
 * @since Grocery Online Store 1.0.1
 */

/**
 * Registers block patterns and categories.
 *
 * @since Grocery Online Store 1.0.1
 *
 * @return void
 */
function grocery_online_store_register_block_patterns() {
	$block_pattern_categories = array(
		'grocery-online-store'    => array( 'label' => __( 'Grocery Online Store', 'grocery-online-store' ) ),
	);

	$block_pattern_categories = apply_filters( 'grocery_online_store_block_pattern_categories', $block_pattern_categories );

	foreach ( $block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'grocery_online_store_register_block_patterns', 9 );
