<?php
/**
 * Legal Counselor functions and definitions
 *
 * @package legal_counselor
 * @since 1.0
 */

if ( ! function_exists( 'legal_counselor_support' ) ) :
	function legal_counselor_support() {

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );

		// Enqueue editor styles.
		add_editor_style( 'style.css' );

	}
endif;

add_action( 'after_setup_theme', 'legal_counselor_support' );

if ( ! function_exists( 'legal_counselor_styles' ) ) :
	function legal_counselor_styles() {
		// Register theme stylesheet.
		$theme_version = wp_get_theme()->get( 'Version' );

		$version_string = is_string( $theme_version ) ? $theme_version : false;
		wp_enqueue_style(
			'legal-counselor-style',
			get_template_directory_uri() . '/style.css',
			array(),
			$version_string
		);
	}
endif;

add_action( 'wp_enqueue_scripts', 'legal_counselor_styles' );

/* Enqueue Js and Css */
function legal_counselor_scripts() {
	wp_enqueue_script( 'legal-counselor-jquery-wow', esc_url(get_template_directory_uri()) . '/assets/js/wow.js', array('jquery') );
	wp_enqueue_style( 'legal-counselor-animate-css', esc_url(get_template_directory_uri()).'/assets/css/animate.css' );
}
add_action( 'wp_enqueue_scripts', 'legal_counselor_scripts' );

/* Theme Credit link */
define('LEGAL_COUNSELOR_BUY_NOW',__('https://www.cretathemes.com/gutenberg/legal-wordpress-theme/','legal-counselor'));
define('LEGAL_COUNSELOR_PRO_DEMO',__('https://www.cretathemes.com/preview/legal-counselor/','legal-counselor'));
define('LEGAL_COUNSELOR_THEME_DOC',__('https://www.cretathemes.com/pro-guide/legal-counselor/','legal-counselor'));
define('LEGAL_COUNSELOR_SUPPORT',__('https://wordpress.org/support/theme/legal-counselor','legal-counselor'));
define('LEGAL_COUNSELOR_REVIEW',__('https://wordpress.org/support/theme/legal-counselor/reviews/#new-post','legal-counselor'));

// Add block patterns
require get_template_directory() . '/inc/block-patterns.php';

// Add block styles
require get_template_directory() . '/inc/block-styles.php';

// Block Filters
require get_template_directory() . '/inc/block-filters.php';

// Svg icons
require get_template_directory() . '/inc/icon-function.php';

// Get Started.
require get_template_directory() . '/inc/get-started/get-started.php';