<?php
/**
 * Block Patterns
 *
 * @package legal_counselor
 * @since 1.0
 */

function legal_counselor_register_block_patterns() {
	$block_pattern_categories = array(
		'legal-counselor' => array( 'label' => esc_html__( 'Legal Counselor', 'legal-counselor' ) ),
		'pages' => array( 'label' => esc_html__( 'Pages', 'legal-counselor' ) ),
	);

	$block_pattern_categories = apply_filters( 'legal_counselor_block_pattern_categories', $block_pattern_categories );

	foreach ( $block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'legal_counselor_register_block_patterns', 9 );