<?php
/**
 * Block Styles
 *
 * @package legal_counselor
 * @since 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	function legal_counselor_register_block_styles() {

		//Wp Block Padding Zero
		register_block_style(
			'core/group',
			array(
				'name'  => 'legal-counselor-padding-0',
				'label' => esc_html__( 'No Padding', 'legal-counselor' ),
			)
		);

		//Wp Block Post Author Style
		register_block_style(
			'core/post-author',
			array(
				'name'  => 'legal-counselor-post-author-card',
				'label' => esc_html__( 'Theme Style', 'legal-counselor' ),
			)
		);

		//Wp Block Button Style
		register_block_style(
			'core/button',
			array(
				'name'         => 'legal-counselor-button',
				'label'        => esc_html__( 'Plain', 'legal-counselor' ),
			)
		);

		//Post Comments Style
		register_block_style(
			'core/post-comments',
			array(
				'name'         => 'legal-counselor-post-comments',
				'label'        => esc_html__( 'Theme Style', 'legal-counselor' ),
			)
		);

		//Latest Comments Style
		register_block_style(
			'core/latest-comments',
			array(
				'name'         => 'legal-counselor-latest-comments',
				'label'        => esc_html__( 'Theme Style', 'legal-counselor' ),
			)
		);


		//Wp Block Table Style
		register_block_style(
			'core/table',
			array(
				'name'         => 'legal-counselor-wp-table',
				'label'        => esc_html__( 'Theme Style', 'legal-counselor' ),
			)
		);


		//Wp Block Pre Style
		register_block_style(
			'core/preformatted',
			array(
				'name'         => 'legal-counselor-wp-preformatted',
				'label'        => esc_html__( 'Theme Style', 'legal-counselor' ),
			)
		);

		//Wp Block Verse Style
		register_block_style(
			'core/verse',
			array(
				'name'         => 'legal-counselor-wp-verse',
				'label'        => esc_html__( 'Theme Style', 'legal-counselor' ),
			)
		);
	}
	add_action( 'init', 'legal_counselor_register_block_styles' );
}
