<?php
/**
 * Title: Shop New Product
 * Slug: organic-food-store/shop-new-product
 * Categories: organic-food-store
 *
 * @package Organic Food Store
 * @since 1.0.0
 */

?>
<!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|40","left":"var:preset|spacing|40"},"blockGap":"var:preset|spacing|50","margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-right:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)"><!-- wp:spacer {"height":"50px","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
<div style="margin-top:0;margin-bottom:0;height:50px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"style":{"typography":{"fontSize":"48px"}}} -->
<h2 class="wp-block-heading" style="font-size:48px"><?php echo esc_html__( 'Hot Deals!', 'organic-food-store' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column {"style":{"spacing":{"padding":{"bottom":"0","top":"0"}}}} -->
<div class="wp-block-column" style="padding-top:0;padding-bottom:0"><!-- wp:group {"style":{"border":{"radius":"10px"},"spacing":{"padding":{"top":"0","bottom":"var:preset|spacing|60"}}},"backgroundColor":"tertiary","className":"hot-deals-columns","layout":{"type":"constrained"}} -->
<div class="wp-block-group hot-deals-columns has-tertiary-background-color has-background" style="border-radius:10px;padding-top:0;padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:image {"align":"center","id":1064,"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":{"topLeft":"10px","topRight":"10px"}}}} -->
<figure class="wp-block-image aligncenter size-full has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/sale-banner-1.jpg" alt="" class="wp-image-1064" style="border-top-left-radius:10px;border-top-right-radius:10px"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
<p class="has-text-align-center has-small-font-size"><?php echo esc_html__( 'JUST ARRIVED', 'organic-food-store' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.5"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size" style="margin-top:0;margin-bottom:0;line-height:1.5"><strong><?php echo esc_html__( 'New Products', 'organic-food-store' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><!-- wp:button {"textAlign":"center"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-text-align-center wp-element-button"><?php echo esc_html__( 'Shop Now', 'organic-food-store' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"10px"},"spacing":{"padding":{"top":"0","bottom":"var:preset|spacing|60"}}},"backgroundColor":"tertiary","className":"hot-deals-columns","layout":{"type":"constrained"}} -->
<div class="wp-block-group hot-deals-columns has-tertiary-background-color has-background" style="border-radius:10px;padding-top:0;padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:image {"align":"center","id":1061,"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":{"topLeft":"10px","topRight":"10px"}}}} -->
<figure class="wp-block-image aligncenter size-full has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/hot-deals-2.jpg" alt="" class="wp-image-1061" style="border-top-left-radius:10px;border-top-right-radius:10px"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php echo esc_html__( 'SAVE BIG', 'organic-food-store' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.5"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size" style="margin-top:0;margin-bottom:0;line-height:1.5"><strong>Sale</strong></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><!-- wp:button {"textAlign":"center"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-text-align-center wp-element-button"><?php echo esc_html__( 'Shop Sale', 'organic-food-store' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"radius":"10px"},"spacing":{"padding":{"top":"0","bottom":"var:preset|spacing|60"}}},"backgroundColor":"tertiary","className":"hot-deals-columns","layout":{"type":"constrained"}} -->
<div class="wp-block-group hot-deals-columns has-tertiary-background-color has-background" style="border-radius:10px;padding-top:0;padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:image {"align":"center","id":1066,"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":{"topLeft":"10px","topRight":"10px"}}}} -->
<figure class="wp-block-image aligncenter size-full has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/hot-deals-3.jpg" alt="" class="wp-image-1066" style="border-top-left-radius:10px;border-top-right-radius:10px"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
<p class="has-text-align-center has-small-font-size"><?php echo esc_html__( 'COLLECTION', 'organic-food-store' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.5"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"large"} -->
<p class="has-text-align-center has-large-font-size" style="margin-top:0;margin-bottom:0;line-height:1.5"><strong><?php echo esc_html__( 'New Collection', 'organic-food-store' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><!-- wp:button {"textAlign":"center"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-text-align-center wp-element-button"><?php echo esc_html__( 'View Collection', 'organic-food-store' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer {"height":"50px"} -->
<div style="height:50px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->